﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace SampleControl
{
    //declare delegates for evennts
    public delegate void MouseAction(int x, int y);

    //declare interface for events
    [Guid("B4EE09C0-B348-428b-BFF6-145DA727605A"),
     InterfaceType(ComInterfaceType.InterfaceIsIDispatch)]
    public interface UserEvents
    {
        [DispIdAttribute(0x60020001)]
        void OnUserClick(int x, int y);
        [DispIdAttribute(0x60020002)]
        void OnUserDblClick(int x, int y);

    }

    //declare an Interface for the control settings
    [Guid("BF3FDC8E-EB8F-4319-A12D-58C18ED5FADC")]
    public interface UserControl1Interface
    {
        void SetBorder(bool bSet);
    }

    [Guid("4C69E367-43AF-4a1c-B5F0-447A36D1DE1B"),
    ComSourceInterfaces(typeof(UserEvents)),
    ClassInterface(ClassInterfaceType.None),]
    public partial class UserControl1 : UserControl, UserControl1Interface
    {
  
        public UserControl1()
        {
            InitializeComponent();
        }
        protected override void OnPaint(PaintEventArgs pe)
        {
            Brush brush = new SolidBrush(Color.BlanchedAlmond);

            pe.Graphics.FillRectangle(brush, ClientRectangle);
        }
        public void SetBorder(bool bSet)
        {
            this.BorderStyle = bSet ? BorderStyle.FixedSingle : BorderStyle.None;
            Refresh();
        }
 
        //Declare Events
        public event MouseAction OnUserClick;
        public event MouseAction OnUserDblClick;

   
  
        private void UserControl1_MouseClick(object sender, MouseEventArgs e)
        {
           if (OnUserClick != null)
            {
                OnUserClick(e.X, e.Y);
            }
        }

        private void UserControl1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
          if (OnUserDblClick != null)
            {
                OnUserDblClick(e.X, e.Y);
            }
        }

    }
}
